﻿param(
  [string]$ManifestPath = ".\manifest\manifest_repro_pack_v1.sha256"
)

$ErrorActionPreference = "Stop"

if (!(Test-Path $ManifestPath)) { throw "Manifest not found: $ManifestPath" }

$lines = Get-Content $ManifestPath | Where-Object { $_.Trim() -ne "" }

$fail = 0
foreach ($line in $lines) {
  # format: "<hash><two spaces><path>"
  $parts = $line -split "\s{2,}", 2
  if ($parts.Count -ne 2) { Write-Host "BAD LINE: $line"; $fail++; continue }

  $expected = $parts[0].Trim().ToLower()
  $pathRel = $parts[1].Trim()

  if (!(Test-Path $pathRel)) { Write-Host "MISSING: $pathRel"; $fail++; continue }

  $actual = (Get-FileHash $pathRel -Algorithm SHA256).Hash.ToLower()
  if ($actual -ne $expected) {
    Write-Host "FAIL: $pathRel"
    Write-Host "  expected: $expected"
    Write-Host "  actual  : $actual"
    $fail++
  } else {
    Write-Host "OK: $pathRel"
  }
}

if ($fail -gt 0) {
  throw "$fail file(s) failed verification."
}

Write-Host "All files verified."
